# Generated by Django 5.2.6 on 2025-09-23 20:12

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('condominio', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Gasto',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('monto', models.DecimalField(decimal_places=2, max_digits=10)),
                ('fecha_emision', models.DateField(auto_now_add=True)),
                ('fecha_vencimiento', models.DateField()),
                ('descripcion', models.CharField(max_length=255)),
                ('pagado', models.BooleanField(default=False)),
                ('propiedad', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='gastos', to='condominio.propiedad')),
            ],
        ),
        migrations.CreateModel(
            name='Pago',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('monto_pagado', models.DecimalField(decimal_places=2, max_digits=10)),
                ('fecha_pago', models.DateTimeField(auto_now_add=True)),
                ('comprobante', models.CharField(blank=True, max_length=255, null=True)),
                ('gasto', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagos', to='finanzas.gasto')),
                ('usuario', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagos', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Reserva',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fecha_reserva', models.DateField()),
                ('hora_inicio', models.TimeField()),
                ('hora_fin', models.TimeField()),
                ('fecha_creacion', models.DateTimeField(auto_now_add=True)),
                ('costo_total', models.DecimalField(decimal_places=2, default=0.0, max_digits=8)),
                ('pagada', models.BooleanField(default=False)),
                ('area_comun', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reservas', to='condominio.areacomun')),
                ('usuario', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reservas', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
