# backend/config/urls.py (CORREGIDO)

from django.contrib import admin
from django.urls import path, include
from django.conf import settings

from django.conf.urls.static import static
from rest_framework.authtoken.views import obtain_auth_token
from usuarios.views import RegistroView, RegistrarDispositivoView
from rest_framework.authtoken.views import obtain_auth_token
from django.urls import path, include
from drf_spectacular.views import (
    SpectacularAPIView,
    SpectacularSwaggerView,
    SpectacularRedocView,
)

urlpatterns = [
    path('admin/', admin.site.urls),

    # Autenticación y registro de usuarios (se quedan en la raíz de la API)
    path('api/login/', obtain_auth_token, name='api_token_auth'),
    path('api/registro/', RegistroView.as_view(), name='api_registro'),
    path('api/dispositivos/registrar/', RegistrarDispositivoView.as_view(), name='registrar_dispositivo'),
    path('api/schema/', SpectacularAPIView.as_view(), name='schema'),
    path('api/schema/swagger-ui/', SpectacularSwaggerView.as_view(url_name='schema'), name='swagger-ui'),
    path('api/schema/redoc/', SpectacularRedocView.as_view(url_name='schema'), name='redoc'),

    # Endpoints de cada app con su propio prefijo
    path('api/usuarios/', include('usuarios.urls')),
    path('api/condominio/', include('condominio.urls')),
    path('api/finanzas/', include('finanzas.urls')),
    path("api/seguridad/", include(("seguridad.urls", "seguridad"), namespace="seguridad")),

    path('api/mantenimiento/', include('mantenimiento.urls')), # <-- AHORA TIENE SU PREFIJO

    # URLs para la API navegable
    path('api-auth/', include('rest_framework.urls')),
   path("api/schema/", SpectacularAPIView.as_view(), name="schema"),
    path("api/docs/", SpectacularSwaggerView.as_view(url_name="schema"), name="swagger-ui"),
    path("api/redoc/", SpectacularRedocView.as_view(url_name="schema"), name="redoc"),
    path("api/notificaciones/", include(("notificaciones.urls", "notificaciones"), namespace="notificaciones")),
]
if settings.DEBUG:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)